//-----------------------------------------------------------------------------
//                  Janich & Klass Computertechnik GmbH, Germany
//            Copyright (c) 2002-2010 by Janich & Klass Computertechnik
//                              All rights reserved
//
//  File: F3Fcts.cpp
//  Date: 31.05.2002 08:28:12
//
//  Purpose:
//      Samples for the F3-Function in DpuScan's UDDs
//  Environment:
//      Generatet and compiled with the german version 
//      of Microsoft Visual Studio 6.
//      This DLL uses the Microsoft Foundation Classes (MFC) statically
//  Notes:
//      All sample function can be also build without MFC
//-----------------------------------------------------------------------------

#include "stdafx.h"
#include "F3Fcts.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


BEGIN_MESSAGE_MAP(CF3FctsApp, CWinApp)
	//{{AFX_MSG_MAP(CF3FctsApp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CF3FctsApp::CF3FctsApp()
{
}

CF3FctsApp theApp;

char sOut[1024];



//-----------------------------------------------------------------------------
//char* WINAPI Upper(char* sIn)
//Params:
//  sIn     points to the zero terminated ansi string
//Return:
//  sOut    points to the DLLs global internal buffer which hold s the result 
//          of the string operation
//Remark:
//  Converts lower case to upper case
//-----------------------------------------------------------------------------
char* WINAPI Upper(char* sIn)
{AFX_MANAGE_STATE(AfxGetStaticModuleState());
CString s = sIn;
    s.MakeUpper();
    strncpy(sOut,(LPCTSTR)s,1024);   
    return (sOut);
}

//-----------------------------------------------------------------------------
//char* WINAPI Lower(char* sIn)
//Params:
//  sIn     points to the zero terminated ansi string
//Return:
//  sOut    points to the DLLs global internal buffer which hold s the result 
//          of the string operation
//Remark:
//  Converts upper case to lower case
//-----------------------------------------------------------------------------
char* WINAPI Lower(char* sIn)
{AFX_MANAGE_STATE(AfxGetStaticModuleState());
CString s = sIn;
    s.MakeLower();
    strncpy(sOut,(LPCTSTR)s,1024);   
    return (sOut);
}

//-----------------------------------------------------------------------------
//char* WINAPI Capitalize(char* sIn)
//Params:
//  sIn     points to the zero terminated ansi string
//Return:
//  sOut    points to the DLLs global internal buffer which hold s the result 
//          of the string operation
//Remark:
//  Converts lower case to upper case and makes the first character uppercase
//-----------------------------------------------------------------------------
char* WINAPI Capitalize(char* sIn)
{AFX_MANAGE_STATE(AfxGetStaticModuleState());
CString s = sIn;
    *sOut=0;
    if( s.GetLength()>0 )
    {

        s.MakeLower();
        strncpy(sOut,(LPCTSTR)s,1024);   
        s.MakeUpper();
        sOut[0] = s[0];
    }
    return (sOut);
}


//-----------------------------------------------------------------------------
//char* WINAPI CN_ISBN(char* sIn)
//Params:
//  sIn     points to the zero terminated ansi string
//Return:
//  sOut    points to the DLLs global internal buffer which hold s the result 
//          of the string operation
//Remark:
//  Checks a given string to be an International Standard Booknumber where 
//  every non-digit is ignored. The string with the digits only is returned.
//-----------------------------------------------------------------------------
char* WINAPI CN_ISBN(char* sIn)
{//AFX_MANAGE_STATE(AfxGetStaticModuleState());
char *p = sIn;
char *q = sOut;
BOOL b=FALSE;

    if( strlen(sIn)>8 && strlen(sIn) < 1024 )
    {
    int ck;

        // stripping blanks, dashes, ...
        do
        {
            if( isdigit(*p) )
                *q++=*p;
        }
        while(*p++);

        // build the checksum
        *q=0;
        ck  = (sOut[ 0]-'0')*10 
            + (sOut[ 1]-'0')*9 
            + (sOut[ 2]-'0')*8 
            + (sOut[ 3]-'0')*7 
            + (sOut[ 4]-'0')*6 
            + (sOut[ 5]-'0')*5 
            + (sOut[ 6]-'0')*4 
            + (sOut[ 7]-'0')*3 
            + (sOut[ 8]-'0')*2 
            ;
        ck = 11 - ck%11;

        if(ck == (sOut[9]-'0') ) 
            b=TRUE;
    }

    if( !b )
        MessageBox(NULL,"No ISBN!","Check ISBN",0);
    return (sOut);
}


//-----------------------------------------------------------------------------
//char* WINAPI ValidateManual(char* sIn)
//Params:
//  sIn     points to the zero terminated ansi string
//Return:
//  sOut    points to the DLLs global internal buffer which hold s the result 
//          of the string operation
//Remark:
//  Sample for a manual validation. Replace this with your checking and 
//  validation routines.
//-----------------------------------------------------------------------------
char* WINAPI ValidateManual(char* sIn)
{AFX_MANAGE_STATE(AfxGetStaticModuleState());
CString s = sIn;
    s += " Ok?";
    if(AfxMessageBox(s,MB_YESNO)== IDNO)
        s.Format("Not valid : %s",sIn);
    else
        s = sIn;
    strncpy(sOut,(LPCTSTR)s,1024);   
    return (sOut);
}


// End of file F3Fcts.cpp
//-----------------------------------------------------------------------------
