//---------------------------------------------------------------------------
//
//  [ BROKER.C ]  Sample DLL for BROKER calls may be used for Win32
//
//  History
//
//  Test DLL for DpuScan Version > 3.06
//
//  1.1 0.1  first version                                     09.Feb.1997 stv
//  corrections: WINAPI, declspec                              29.Jun.2000 hws
//  demonstrate: DpuScan sends multiple lines                  25.Jun.2010 hws
//---------------------------------------------------------------------------

#define STRICT

#include <windows.h>
#include <windowsx.h>
#include <tchar.h>

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#ifdef _WIN32
  #include "winver.h"
#else
  #include "ver.h"
#endif

#include "broker.h"

#pragma warning (disable : 4996)
//---------------------------------------------------------------------------
//  data
//---------------------------------------------------------------------------

#define   MAXSIZE 512              // maximum size of DLL internal buffer

HINSTANCE hDLLInstance;            // myHandle

char      DLLPath[_MAX_PATH];      // myPath

//---------------------------------------------------------------------------
//  functions
//---------------------------------------------------------------------------
#include <malloc.h>

__declspec(dllexport) int WINAPI EntryPoint(LPSTR input,DWORD inputsize)
{
int   res   =  0;
char  *temp, *p, *q;
FILE *target= NULL;

   //-----------------------------------------------------------------------
   // sample code for broker function


  if (inputsize < 32000) // reasonable values only
  {
    temp= (char *) malloc((inputsize+16)*sizeof(char));
    if (temp)
    {
      lstrcpy(temp,input);                     // copy external data to internal buffer  
      q= temp;
      memset (&(q[inputsize]),0,4);

      while (p= strchr(q,'\r'))                 // For each broker line sent simultaneously.
      {                                         // This loop is useful if there wasn't just
      char c= p[2];                             // writing to the very same file.
      
        p[2]= 0;
        target = fopen(DLLPath,"ab");           // open target file for append
        res= -1;
        if (target)
        {
        int resC;

          res    = fputs(temp,target);          // write data
          resC   = fclose(target);              // close target file
          
          if (res)  res= -2;
          if (resC) res= -3;         
        }
        if (res) break;                         // exit on error

        //-----------------------------------------------------------------------
        // add further broker funtion code here
        //-----------------------------------------------------------------------

        p[2]= c;                                // advance one line
        q   = &(p[2]);                          // skip <cr><lf>
      }
      free(temp);
    }
  }
                                           // only if no error is reported 
  return(res);                             // dpuscan will continue to work
}                                          // an error value is always < 0
                                           // values > 0 are stored to a %code
//---------------------------------------------------------------------------
//  main-programm 
//---------------------------------------------------------------------------

int static LibStart (void)
{
    GetModuleFileName(hDLLInstance,DLLPath,sizeof(DLLPath)); // Get path to the broker dll
   
    lstrcpy(lstrrchr(DLLPath,'.'),".DIF");                   // create filename for output 
    
    //-----------------------------------------------------------------------
    // add further broker setup code here
    
    
    //-----------------------------------------------------------------------
    
    return(TRUE);  // everything is ok
}

//---------------------------------------------------------------------------
// LibInit-Function
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// WIN32 DLL main
//---------------------------------------------------------------------------

BOOL WINAPI DllMain (HANDLE hModule, DWORD fdwReason, LPVOID lpReserved)
{
    int res = 0;
    
    switch (fdwReason)
    {
      case DLL_PROCESS_ATTACH:
           {
           hDLLInstance = hModule;
           res          = LibStart();
           break;
           }
      case DLL_THREAD_ATTACH: break;
      case DLL_THREAD_DETACH: break;
      case DLL_PROCESS_DETACH:
           {
           break;
           }
    }
    return(res);
}

//---------------------------------------------------------------------------

